import { ScrollText, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <ScrollText className="footer-logo-icon" size={24} strokeWidth={1.5} />
              <h2 className="footer-logo-text">Наследие</h2>
            </div>
            <p className="footer-description">
              Погрузитесь в богатую историю и культуру с нашими профессиональными экскурсоводами. 
              Откройте для себя наследие прошлого через увлекательные экскурсии.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои экскурсии</a></li>
              <li><a href="/book">Записаться</a></li>
              <li><a href="#">Коллекции</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={14} strokeWidth={1.5} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={14} strokeWidth={1.5} />
                <a href="mailto:info@excursions.ru">info@excursions.ru</a>
              </li>
              <li>
                <MapPin size={14} strokeWidth={1.5} />
                <span>Москва, ул. Историческая, 12</span>
              </li>
              <li>
                <Clock size={14} strokeWidth={1.5} />
                <span>Пн-Вс: 10:00 - 19:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Экскурсии. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer
